Shader "!FullControl/Misc/Additive RGB Alpha Offset" {
Properties {
	_TintColor ("Tint Color", Color) = (0.5,0.5,0.5,0.5)
	_MainTex ("TextureA", 2D) = "white" {}	
	_MainTexB ("TextureB", 2D) = "white" {}	
	_Opacity ("Opacity", Float) = 1.0
	
	_InvFade ("Soft Particles Factor", Range(0.01,3.0)) = 1.0
	_TexAOffsetX ("Texture A Offset X", Float) = 0.0
	_TexAOffsetY ("Texture A Offset Y", Float) = 0.0
	_TexBOffsetX ("Texture A Offset X", Float) = 0.0
	_TexBOffsetY ("Texture B Offset Y", Float) = 0.0
}

Category {
	Tags { "Queue"="Transparent" "IgnoreProjector"="True" "RenderType"="Transparent" }
	Blend SrcAlpha One
	AlphaTest Greater .01
	ColorMask RGB
	Cull Off Lighting Off ZWrite Off Fog { Color (0,0,0,0) }
	BindChannels {
		Bind "Color", color
		Bind "Vertex", vertex
		Bind "TexCoord", texcoord
	}
	
	// ---- Fragment program cards
	SubShader {
		Pass {
		
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag
			#pragma fragmentoption ARB_precision_hint_fastest
			#pragma multi_compile_particles

			#include "UnityCG.cginc"

			sampler2D _MainTex;
			sampler2D _MainTexB;
			fixed4 _TintColor;
			float _Opacity;
			float _TexAOffsetX;
			float _TexAOffsetY;
			float _TexBOffsetX;
			float _TexBOffsetY;
			
			struct appdata_t {
				float4 vertex : POSITION;
				fixed4 color : COLOR;
				float2 texcoord : TEXCOORD0;
			};

			struct v2f {
				float4 vertex : POSITION;
				fixed4 color : COLOR;
				float2 texcoord : TEXCOORD0;
				float2 texcoordB : TEXCOORD2;
		
				#ifdef SOFTPARTICLES_ON
				float4 projPos : TEXCOORD1;
				#endif
			};
			
			float4 _MainTex_ST;

			v2f vert (appdata_t v)
			{
				v2f o;
				o.vertex = mul(UNITY_MATRIX_MVP, v.vertex);
				#ifdef SOFTPARTICLES_ON
				o.projPos = ComputeScreenPos (o.vertex);
				COMPUTE_EYEDEPTH(o.projPos.z);
				#endif
				o.color = v.color;
				o.texcoord = TRANSFORM_TEX(v.texcoord,_MainTex);
				o.texcoord.x += _TexAOffsetX;
				o.texcoord.y += _TexAOffsetY;
				
				o.texcoordB = TRANSFORM_TEX(v.texcoord,_MainTex);
				o.texcoordB.x += _TexBOffsetX;
				o.texcoordB.y += _TexBOffsetY;
				
				return o;
			}

			sampler2D _CameraDepthTexture;
			float _InvFade;
			
			fixed4 frag (v2f i) : COLOR
			{
				#ifdef SOFTPARTICLES_ON
				float sceneZ = LinearEyeDepth (UNITY_SAMPLE_DEPTH(tex2Dproj(_CameraDepthTexture, UNITY_PROJ_COORD(i.projPos))));
				float partZ = i.projPos.z;
				float fade = saturate (_InvFade * (sceneZ-partZ));
				i.color.a *= fade;
				#endif
			
				return 2.0f * i.color * _TintColor * tex2D(_MainTex, i.texcoord) * tex2D(_MainTexB, i.texcoordB) * _Opacity;
			}
			ENDCG 
		}
	} 	
	
	// ---- Dual texture cards
	SubShader {
		Pass {
			SetTexture [_MainTex] {
				constantColor [_TintColor]
				combine constant * primary
			}
			SetTexture [_MainTex] {
				combine texture * previous DOUBLE
			}
		}
	}
	
	// ---- Single texture cards (does not do color tint)
	SubShader {
		Pass {
			SetTexture [_MainTex] {
				combine texture * primary
			}
		}
	}
}
}
